/*
 * Decompiled with CFR 0.152.
 */
package music;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JLabel;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;
import music.Main;
import music.commonUtils;
import music.settings;

public class backgroundMusic
extends JLabel
implements Runnable {
    private static final long serialVersionUID = 300L;
    private static final String musicFolder = "music";
    private String currentSong = null;
    private boolean isEnabled = settings.music;
    private Image backgroundImage = null;
    private Thread musicThread = null;
    private static final int EXTERNAL_BUFFER_SIZE = 128;
    private Player myPlayer;
    public static String[] trackList = new String[]{"1812.mp3", "bumblebee.mp3", "valkyrie.mp3", "mars.mp3", "symphony8_2.mp3", "gladiator.mp3", "carnival.mp3"};

    public backgroundMusic(String song) {
        if (song.length() == 0) {
            song = this.randomSong();
        }
        this.currentSong = backgroundMusic.hasNoExtension(song) ? this.makeMP3(song) : song;
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent evt) {
                if (backgroundMusic.this.isEnabled) {
                    backgroundMusic.this.off();
                    settings.write(false);
                } else {
                    backgroundMusic.this.on();
                    settings.write(true);
                }
                backgroundMusic.this.flushGraphics();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        if (this.isEnabled) {
            this.musicThread = new Thread(this);
            this.musicThread.start();
        }
    }

    public backgroundMusic() {
        this("");
    }

    public void playRandomSong() {
        this.changeTrack(this.randomSong(), false);
    }

    public void playRandomSong(boolean waitForCurrentToFinish) {
        this.changeTrack(this.randomSong(), waitForCurrentToFinish);
    }

    public String randomSong() {
        return commonUtils.choice(trackList);
    }

    public void off() {
        this.isEnabled = false;
    }

    public void on() {
        if (this.isEnabled) {
            return;
        }
        this.musicThread = new Thread(this);
        this.musicThread.start();
        this.isEnabled = true;
    }

    public void changeTrack(String trackName) {
        this.changeTrack(trackName, false);
    }

    public void changeTrack(String trackName, boolean waitForCurrentToFinish) {
        if (!this.isEnabled) {
            return;
        }
        if (waitForCurrentToFinish) {
            this.currentSong = backgroundMusic.hasNoExtension(trackName) ? this.makeMP3(trackName) : trackName;
        } else {
            block5: {
                this.off();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    if (!Main.debugErrors) break block5;
                    System.out.println(ex);
                }
            }
            this.currentSong = backgroundMusic.hasNoExtension(trackName) ? this.makeMP3(trackName) : trackName;
            this.on();
        }
    }

    private void flushGraphics() {
        this.paintComponent(this.getGraphics());
    }

    private String makeMP3(String old) {
        return old + ".mp3";
    }

    private String addFolder(String old) {
        return musicFolder + File.separator + old;
    }

    public void run() {
        while (this.isEnabled) {
            block32: {
                this.verifyFile();
                File soundFile = new File(this.currentSong);
                if (this.currentSong.toLowerCase().endsWith(".mid") || this.currentSong.toLowerCase().endsWith(".midi")) {
                    try {
                        Sequence sequence = MidiSystem.getSequence(soundFile);
                        Sequencer sequencer = MidiSystem.getSequencer();
                        sequencer.open();
                        sequencer.setSequence(sequence);
                        sequencer.start();
                        while (this.isEnabled && sequencer.isRunning()) {
                            Thread.sleep(100L);
                        }
                        if (sequencer.isRunning()) {
                            sequencer.stop();
                        }
                        break block32;
                    }
                    catch (Exception e) {
                        if (Main.debugErrors) {
                            System.out.println("Couldn't play midi at " + soundFile.getAbsolutePath() + '\n' + e);
                        }
                        break block32;
                    }
                }
                if (this.currentSong.toLowerCase().endsWith(".mp3")) {
                    FileInputStream inputStream = null;
                    try {
                        inputStream = new FileInputStream(soundFile);
                    }
                    catch (Exception e) {
                        if (Main.debugErrors) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    try {
                        this.myPlayer = new Player(inputStream);
                        PlayerThread pt = new PlayerThread();
                        pt.start();
                        while (this.isEnabled && !this.myPlayer.isComplete()) {
                            Thread.sleep(100L);
                        }
                        if (!this.myPlayer.isComplete()) {
                            pt.interrupt();
                            this.myPlayer = null;
                        }
                        ((InputStream)inputStream).close();
                    }
                    catch (JavaLayerException ex) {
                        if (Main.debugErrors) {
                            System.out.println(ex);
                        }
                        break block32;
                    }
                    catch (Exception e) {
                        if (Main.debugErrors) {
                            System.out.println(e);
                        }
                        break block32;
                    }
                }
                AudioInputStream audioInputStream = null;
                try {
                    audioInputStream = AudioSystem.getAudioInputStream(soundFile);
                }
                catch (Exception e) {
                    if (Main.debugErrors) {
                        e.printStackTrace();
                        if (soundFile.exists()) {
                            System.out.println("File at " + soundFile.getAbsolutePath() + " exists but we can't play it.");
                        } else {
                            System.out.println("File doesn't exist.");
                        }
                    }
                    return;
                }
                AudioFormat audioFormat = audioInputStream.getFormat();
                SourceDataLine line = null;
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                if (!AudioSystem.isLineSupported(info)) {
                    AudioFormat pcm = new AudioFormat(audioFormat.getSampleRate(), 16, audioFormat.getChannels(), true, false);
                    audioInputStream = AudioSystem.getAudioInputStream(pcm, audioInputStream);
                    audioFormat = audioInputStream.getFormat();
                    info = new DataLine.Info(SourceDataLine.class, audioFormat);
                }
                try {
                    line = (SourceDataLine)AudioSystem.getLine(info);
                    line.open(audioFormat);
                }
                catch (LineUnavailableException e) {
                    if (Main.debugErrors) {
                        e.printStackTrace();
                    }
                    return;
                }
                catch (Exception e) {
                    if (Main.debugErrors) {
                        e.printStackTrace();
                    }
                    return;
                }
                line.start();
                int nBytesRead = 0;
                byte[] abData = new byte[128];
                while (nBytesRead != -1 && this.isEnabled) {
                    try {
                        nBytesRead = audioInputStream.read(abData, 0, abData.length);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (nBytesRead < 0) continue;
                    int nBytesWritten = line.write(abData, 0, nBytesRead);
                }
                line.drain();
                line.close();
            }
            if (!this.isEnabled) continue;
            this.playRandomSong();
        }
    }

    protected void paintComponent(Graphics g) {
        block2: {
            String picName = this.isEnabled ? "img" + File.separator + "speakerOn.png" : "img" + File.separator + "speakerOff.png";
            try {
                this.backgroundImage = ImageIO.read(new File(picName));
            }
            catch (IOException e) {
                if (!Main.debugErrors) break block2;
                System.out.println(e + " " + picName);
            }
        }
        g.clearRect(0, 0, this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null));
        g.drawImage(this.backgroundImage, 0, 0, this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null), 0, 0, this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null), null);
    }

    private static boolean hasNoExtension(String trackName) {
        if (trackName.indexOf(".") == -1) {
            return true;
        }
        return trackName.indexOf(".", trackName.length() - 5) == 1 || trackName.indexOf(".", trackName.length() - 5) == 0;
    }

    private void verifyFile() {
        File f = new File(this.currentSong);
        if (!f.exists()) {
            this.currentSong = this.addFolder(this.currentSong);
            f = new File(this.currentSong);
            if (!f.exists()) {
                if (Main.debugErrors) {
                    System.out.println("File not found at: " + this.currentSong);
                }
                this.currentSong = this.randomSong();
            }
        }
    }

    private class PlayerThread
    extends Thread {
        private PlayerThread() {
        }

        public void run() {
            try {
                backgroundMusic.this.myPlayer.play();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

